select   daten.Bezeichnung,
         daten.Kuerzel,
         daten.VKZ as Vorgangskennzeichen,

         sum(daten.Jahr1) as "Jahressumme vor 5 Jahren",
         sum(daten.Jahr2) as "Jahressumme vor 4 Jahren",
         sum(daten.Jahr3) as "Jahressumme vor 3 Jahren",
         sum(daten.Jahr4) as "Jahressumme vor 2 Jahren",
         sum(daten.Jahr5) as "Jahressumme vor 1 Jahr"

from     (
         select   'Basiszahl 226.2' as Bezeichnung,
                  nvl(k.kennzeichen,'(ohne)') as Kuerzel,
                  nvl(k.bezeichnung,'(ohne)') as VKZ,

                  count(distinct(case when to_number(to_char(m.bisdatum,'yyyy')) = to_number(to_char(sysdate,'yyyy'))-5
                                      then h.massnahme else null end)) as Jahr1,
                             
                  count(distinct(case when to_number(to_char(m.bisdatum,'yyyy')) = to_number(to_char(sysdate,'yyyy'))-4
                                      then h.massnahme else null end)) as Jahr2,
                             
                  count(distinct(case when to_number(to_char(m.bisdatum,'yyyy')) = to_number(to_char(sysdate,'yyyy'))-3
                                      then h.massnahme else null end)) as Jahr3,   
                             
                  count(distinct(case when to_number(to_char(m.bisdatum,'yyyy')) = to_number(to_char(sysdate,'yyyy'))-2
                                      then h.massnahme else null end)) as Jahr4,
                             
                  count(distinct(case when to_number(to_char(m.bisdatum,'yyyy')) = to_number(to_char(sysdate,'yyyy'))-1
                                      then h.massnahme else null end)) as Jahr5   
                                      
         from     n_vorgang v inner join n_vorgmassnahme h on v.vorgangsnummer = h.vorgang
                              inner join n_stat8a s on h.massnahme = s.massnahmennummer      
                              inner join n_massnahme m on h.massnahme = m.massnahmennummer
                              left join n_kennz k on v.kennz_fk = k.lfdnr

         where    s.freigegeben = '1'
         and      s.ef18 in ('3','4')

         group by nvl(k.kennzeichen,'(ohne)'),
                  nvl(k.bezeichnung,'(ohne)')

         ) daten
         
group by daten.Bezeichnung,
         daten.Kuerzel,
         daten.VKZ

order by daten.Bezeichnung,
         daten.Kuerzel,
         daten.VKZ